<?php
// Include database configuration
include 'db.php';

// Handle price update
if (isset($_POST['update'])) {
    $pnet = $_POST['pnet'];
    $ptype = $_POST['ptype'];
    $percentage = $_POST['percentage'];
    
    if (is_numeric($percentage)) {
        $factor = 1 + ($percentage / 100);
        $sql = "UPDATE plans SET 
                    pamount = ROUND(pamount * $factor), 
                    pamount_api = ROUND(pamount_api * $factor), 
                    pamount_vendor = ROUND(pamount_vendor * $factor) 
                WHERE pnet = '$pnet' AND ptype = '$ptype'";
        
        if ($conn->query($sql) === TRUE) {
            echo "<p style='color: green;'>Prices updated successfully!</p>";
        } else {
            echo "<p style='color: red;'>Error updating prices: " . $conn->error . "</p>";
        }
    } else {
        echo "<p style='color: red;'>Invalid percentage value!</p>";
    }
}

// Fetch available plans
$result = $conn->query("SELECT DISTINCT pnet FROM plans");
$pnet_options = "";
while ($row = $result->fetch_assoc()) {
    $pnet_options .= "<option value='" . $row['pnet'] . "'>" . strtoupper($row['pnet']) . "</option>";
}

$result = $conn->query("SELECT DISTINCT ptype FROM plans");
$ptype_options = "";
while ($row = $result->fetch_assoc()) {
    $ptype_options .= "<option value='" . $row['ptype'] . "'>" . strtoupper($row['ptype']) . "</option>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Prices</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        form { max-width: 400px; padding: 20px; border: 1px solid #ccc; }
        input, select, button { display: block; width: 100%; margin: 10px 0; padding: 10px; }
        button { background-color: #28a745; color: white; border: none; cursor: pointer; }
        button:hover { background-color: #218838; }
    </style>
</head>
<body>
    <h2>Update Plan Prices</h2>
    <form method="POST">
        <label for="pnet">Select Network:</label>
        <select name="pnet" required>
            <?php echo $pnet_options; ?>
        </select>
        
        <label for="ptype">Select Plan Type:</label>
        <select name="ptype" required>
            <?php echo $ptype_options; ?>
        </select>
        
        <label for="percentage">Increase/Decrease by (%):</label>
        <input type="number" name="percentage" placeholder="e.g., 3 for +3%" required>
        
        <button type="submit" name="update">Update Prices</button>
    </form>
</body>
</html>

<?php $conn->close(); ?>
