<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit();
}
include 'db.php';

$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;
$order = isset($_GET['order']) ? $_GET['order'] : 'DESC';
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';

$totalQuery = mysqli_query($conn, "SELECT COUNT(*) as total FROM users WHERE email LIKE '%$search%' OR firstName LIKE '%$search%' OR lastName LIKE '%$search%' OR phone LIKE '%$search%' OR role LIKE '%$search%' OR state LIKE '%$search%'");
$total = mysqli_fetch_assoc($totalQuery)['total'];
$pages = ceil($total / $limit);

$result = mysqli_query($conn, "SELECT email, firstName, lastName, phone, role, state FROM users WHERE email LIKE '%$search%' OR firstName LIKE '%$search%' OR lastName LIKE '%$search%' OR phone LIKE '%$search%' OR role LIKE '%$search%' OR state LIKE '%$search%' ORDER BY id $order LIMIT $limit OFFSET $offset");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        header {
            background-color: #343a40;
        }
        footer {
            background-color: #343a40;
        }
        .pagination {
            justify-content: center;
        }
        .btn-custom {
            background-color: #17a2b8;
            color: white;
        }
        .btn-custom:hover {
            background-color: #138496;
        }
        .table th, .table td {
            text-align: center;
        }
        .search-form {
            max-width: 600px;
            margin: 0 auto;
        }
    </style>
</head>
<body>
    <header class="text-white text-center py-3">
        <h2>Admin Dashboard</h2>
        <a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
    </header>
    <div class="container mt-5">
        <h2 class="text-center">User Management</h2>
        <p class="text-center">Total Users: <?= $total; ?></p>

        <!-- Entries per page and Sort options -->
        <div class="d-flex justify-content-between mb-3 flex-wrap">
            <div class="d-flex align-items-center mb-2 mb-md-0">
                <label class="me-2">Show</label>
                <select onchange="window.location.href='dashboard.php?limit=' + this.value" class="form-select form-select-sm w-auto">
                    <option value="10" <?= $limit == 10 ? 'selected' : '' ?>>10</option>
                    <option value="20" <?= $limit == 20 ? 'selected' : '' ?>>20</option>
                    <option value="50" <?= $limit == 50 ? 'selected' : '' ?>>50</option>
                </select>
                <label class="ms-2">entries</label>
            </div>

            <div class="d-flex align-items-center mb-2 mb-md-0">
                <a href="dashboard.php?order=ASC" class="btn btn-sm btn-secondary me-2">Sort Ascending</a>
                <a href="dashboard.php?order=DESC" class="btn btn-sm btn-secondary">Sort Descending</a>
            </div>

            <!-- Search Form -->
            <div class="search-form">
                <form method="GET" action="dashboard.php" class="d-flex">
                    <input type="text" name="search" value="<?= $search ?>" class="form-control me-2" placeholder="Search users">
                    <button type="submit" class="btn btn-custom">Search</button>
                </form>
            </div>
        </div>

        <!-- Table -->
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Email</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Phone</th>
                    <th>Role</th>
                    <th>State</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                <tr>
                    <td><?= $row['email']; ?></td>
                    <td><?= $row['firstName']; ?></td>
                    <td><?= $row['lastName']; ?></td>
                    <td><?= $row['phone']; ?></td>
                    <td><?= $row['role']; ?></td>
                    <td><?= $row['state']; ?></td>
                    <td>
                        <a href="view.php?id=<?= $row['email']; ?>" class="btn btn-info btn-sm">View</a>
                        <a href="edit.php?id=<?= $row['email']; ?>" class="btn btn-warning btn-sm">Edit</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <!-- Pagination -->
        <nav>
            <ul class="pagination">
                <li class="page-item <?= $page == 1 ? 'disabled' : '' ?>">
                    <a class="page-link" href="dashboard.php?page=<?= $page - 1 ?>&limit=<?= $limit ?>&order=<?= $order ?>&search=<?= $search ?>">Previous</a>
                </li>
                <li class="page-item <?= $page == $pages ? 'disabled' : '' ?>">
                    <a class="page-link" href="dashboard.php?page=<?= $page + 1 ?>&limit=<?= $limit ?>&order=<?= $order ?>&search=<?= $search ?>">Next</a>
                </li>
            </ul>
        </nav>
    </div>

    <footer class="text-white text-center py-3 mt-5">
        <p>&copy; <?= date('Y'); ?> Admin Panel. All Rights Reserved.</p>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
