<?php 
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit();
}
include 'db.php';

if (!isset($_GET['user'])) {
    header("Location: transactions.php");
    exit();
}

$user_email = $_GET['user'];

// Pagination variables
$limit = 10; // Limit per page
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$start = ($page - 1) * $limit;

// Query with pagination
$result = mysqli_query($conn, "SELECT * FROM transactions WHERE user='$user_email' ORDER BY id DESC LIMIT $start, $limit");

// Count total records for pagination
$totalResult = mysqli_query($conn, "SELECT COUNT(*) AS total FROM transactions WHERE user='$user_email'");
$totalRecords = mysqli_fetch_assoc($totalResult)['total'];
$totalPages = ceil($totalRecords / $limit);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>User Transactions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <header class="bg-dark text-white text-center py-3">
        <h2>Transactions for <?= htmlspecialchars($user_email); ?></h2>
        <a href="transactions.php" class="btn btn-secondary btn-sm">Back</a>
    </header>
    <div class="container mt-5">
        <h2 class="text-center">Transaction List</h2>
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Transaction ID</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                <tr>
                    <td><?= $row['transaction_id']; ?></td>
                    <td><?= $row['type']; ?></td>
                    <td><?= $row['amount']; ?></td>
                    <td><?= $row['status']; ?></td>
                    <td><?= $row['whenn']; ?></td>
                    <td>
                        <a href="transaction_details.php?id=<?= $row['id']; ?>" class="btn btn-primary btn-sm">View</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <!-- Pagination -->
        <nav>
            <ul class="pagination justify-content-center">
                <li class="page-item <?= $page <= 1 ? 'disabled' : ''; ?>">
                    <a class="page-link" href="?user=<?= $user_email; ?>&page=<?= $page - 1; ?>">Previous</a>
                </li>
                <li class="page-item <?= $page >= $totalPages ? 'disabled' : ''; ?>">
                    <a class="page-link" href="?user=<?= $user_email; ?>&page=<?= $page + 1; ?>">Next</a>
                </li>
            </ul>
        </nav>
    </div>
    <footer class="bg-dark text-white text-center py-3 mt-5">
        <p>&copy; <?= date('Y'); ?> Admin Panel. All Rights Reserved.</p>
    </footer>
</body>
</html>
