<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit();
}
include 'db.php';

if (!isset($_GET['id'])) {
    die("Invalid transaction ID.");
}

$transaction_id = mysqli_real_escape_string($conn, $_GET['id']);
$result = mysqli_query($conn, "SELECT * FROM transactions WHERE id='$transaction_id'");
if (!$result) {
    die("Query failed: " . mysqli_error($conn));
}
$transaction = mysqli_fetch_assoc($result);
if (!$transaction) {
    echo "<script>alert('Transaction not found!'); window.location.href='transactions.php';</script>";
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Transaction Details</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <header class="bg-dark text-white text-center py-3">
        <h2>Transaction Details</h2>
        <a href="javascript:history.back()" class="btn btn-secondary btn-sm">Back</a>
    </header>
    <div class="container mt-5">
        <h2 class="text-center">Transaction Information</h2>
        <table class="table table-bordered">
            <tr><th>Transaction ID</th><td><?= htmlspecialchars($transaction['transaction_id']); ?></td></tr>
            <tr><th>User</th><td><?= htmlspecialchars($transaction['user']); ?></td></tr>
            <tr><th>Type</th><td><?= htmlspecialchars($transaction['type']); ?></td></tr>
            <tr><th>Amount</th><td><?= htmlspecialchars($transaction['amount']); ?></td></tr>
            <tr><th>Amount Charged</th><td><?= htmlspecialchars($transaction['amount_charged']); ?></td></tr>
            <tr><th>Balance Before</th><td><?= htmlspecialchars($transaction['balance_before']); ?></td></tr>
            <tr><th>Balance After</th><td><?= htmlspecialchars($transaction['balance_after']); ?></td></tr>
            <tr><th>Profit</th><td><?= htmlspecialchars($transaction['profit']); ?></td></tr>
            <tr><th>Beneficiary</th><td><?= htmlspecialchars($transaction['beneficiary']); ?></td></tr>
            <tr><th>Date</th><td><?= htmlspecialchars($transaction['whenn']); ?></td></tr>
            <tr><th>Status</th><td><?= htmlspecialchars($transaction['status']); ?></td></tr>
            <tr><th>Message</th><td><?= htmlspecialchars($transaction['message']); ?></td></tr>
            <tr><th>Service Image</th><td><img src="<?= htmlspecialchars($transaction['serviceImg']); ?>" alt="Service" class="img-fluid" style="max-width: 100px;"></td></tr>
            <tr><th>Data Type</th><td><?= htmlspecialchars($transaction['dataType']); ?></td></tr>
        </table>
    </div>
    <footer class="bg-dark text-white text-center py-3 mt-5">
        <p>&copy; <?= date('Y'); ?> Admin Panel. All Rights Reserved.</p>
    </footer>
</body>
</html>
